/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction;

import com.ibm.hwmca.fw.service.serviceaction.ServiceAction;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionFactory;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.service.serviceaction.mesinstall.PIMesInstallEnclosure;
import com.ibm.hwmca.p.service.serviceaction.mesremove.PIMesRemoveEnclosure;
import com.ibm.hwmca.p.service.serviceaction.repair.FedSwitchRepair;
import com.ibm.hwmca.p.service.serviceaction.repair.PIAIXSAELRepair;
import com.ibm.hwmca.p.service.serviceaction.repair.PIInfoCenterRepair;
import com.ibm.hwmca.p.service.serviceaction.repair.PIRepair;
import com.ibm.hwmca.p.service.serviceaction.replace.PIReplaceEnclosure;
import com.ibm.hwmca.p.service.serviceaction.replace.PIReplaceFrus;
import com.ibm.hwmca.p.service.serviceaction.utils.PIPowerOffLocation;
import com.ibm.hwmca.p.service.serviceaction.utils.PIPowerOnLocation;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PIServiceActionFactory
implements ServiceActionFactory {
    private static final String TRACE_MASKT = "XRVPSAFT";
    private static final String TRACE_MASKF = "XRVPSAFF";
    private static final String TRACE_MASKD = "XRVPSAFD";

    public ServiceAction create(ServiceActionType serviceType, Map userData) throws ServiceActionException {
        Trace.trace(TRACE_MASKF, "PIServiceActionFactory - repair, ServiceActionType=" + serviceType.toString());
        if (serviceType == ServiceActionType.REPAIR_PROBLEM) {
            PIProblem pip;
            String osType;
            CommonProblem cp = (CommonProblem)userData.get("SERVICEABLE_EVENT");
            List frus = cp.getParts();
            if (frus != null) {
                Trace.trace(TRACE_MASKF, "PIServiceActionFactory - repair, number of FRUs=" + frus.size());
                Iterator it = frus.iterator();
                while (it.hasNext()) {
                    CommonPaFru cpf = (CommonPaFru)it.next();
                    String partNum = cpf.getPartNumber();
                    Trace.trace(TRACE_MASKF, "PIServiceActionFactory - repair, partNum=" + partNum);
                    if (partNum == null || !partNum.toUpperCase().startsWith("HPS")) continue;
                    return new FedSwitchRepair();
                }
            } else {
                Trace.trace(TRACE_MASKF, "PIServiceActionFactory - repair, EMPTY FRU LIST");
            }
            if (cp instanceof PIProblem && (osType = (pip = (PIProblem)cp).getPartitionOSType()) != null && osType.trim().toUpperCase().equals("AIX") && (pip.getPlatformLogID() == null || pip.getPlatformLogID().equals("0"))) {
                return new PIAIXSAELRepair();
            }
            int numFrus = cp.getPartCount();
            if (numFrus > 0) {
                return new PIRepair();
            }
            return new PIInfoCenterRepair();
        }
        if (serviceType == ServiceActionType.REPLACE_FRU) {
            return new PIReplaceFrus();
        }
        if (serviceType == ServiceActionType.REPLACE_ENCLOSURE) {
            return new PIReplaceEnclosure();
        }
        if (serviceType == ServiceActionType.MES_INSTALL_FRU) {
            return new PIReplaceFrus();
        }
        if (serviceType == ServiceActionType.MES_INSTALL_ENCLOSURE) {
            if (userData.get("FRAME_LOCATIONS") == null) {
                return new PIMesInstallEnclosure();
            }
            return new PIReplaceFrus();
        }
        if (serviceType == ServiceActionType.MES_REMOVE_FRU) {
            return new PIReplaceFrus();
        }
        if (serviceType == ServiceActionType.MES_REMOVE_ENCLOSURE) {
            return new PIMesRemoveEnclosure();
        }
        if (serviceType == ServiceActionType.POWER_OFF) {
            return new PIPowerOffLocation();
        }
        if (serviceType == ServiceActionType.POWER_ON) {
            return new PIPowerOnLocation();
        }
        throw new ServiceActionException("unsupported ServiceActionType for this impl:" + serviceType);
    }
}

